<?php 
include('include/connect.php');
include('header.php');

// ✅ USER RENEW LOGIC
if(isset($_GET['renew_user'])){
    $uid = intval($_GET['renew_user']);

    // Reset status and start new 30-day period
    $update_status = mysqli_query($connect, "UPDATE tbl_user_register SET status='0' WHERE uid='$uid'");
    $update_date = mysqli_query($connect, "UPDATE tbl_user_game SET added_on=CURDATE() WHERE userId='$uid'");

    if($update_status && $update_date){
        echo "<script>
                alert('User renewed successfully!');
                location.href='user_select_game.php';
              </script>";
        exit;
    } else {
        echo "<script>alert('Error renewing user!');</script>";
        exit;
    }
}
?>

<div class="right_col" role="main">
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <div class="x_panel">
                <div class="x_title">
                    <h2>User Selects Game</h2>
                    <div class="clearfix"></div>
                </div>
                <div class="x_content">
                    <form method="post" class="form-horizontal form-label-left">
                        <div class="form-group">
                            <label class="control-label col-md-4 col-sm-4 col-xs-12">User Name</label>
                            <div class="col-md-8 col-sm-8 col-xs-12">
                                <select class="select2_single form-control" name="username" required>
                                    <option value="">Select User</option>
                                    <?php 
                                        $users = mysqli_query($connect,"SELECT * FROM tbl_user_register");
                                        while($u = mysqli_fetch_assoc($users)){
                                            echo "<option value='{$u['uid']}'>{$u['username']}</option>";
                                        }
                                    ?>
                                </select>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="control-label col-md-4 col-sm-4 col-xs-12">Game</label>
                            <div class="col-md-8 col-sm-8 col-xs-12">
                                <select class="select2_single form-control" name="game" required>
                                    <option value="">Select game</option>
                                    <?php 
                                        $games = mysqli_query($connect,"SELECT * FROM game");
                                        while($g = mysqli_fetch_assoc($games)){
                                            echo "<option value='{$g['sr_no']}'>{$g['game']}</option>";
                                        }
                                    ?>
                                </select>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="control-label col-md-4 col-sm-4 col-xs-12">No of Days</label>
                            <div class="col-md-8 col-sm-8 col-xs-12">
                                <input type="number" class="form-control" name="no_of_days" placeholder="Default 30">
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="col-md-9 col-sm-9 col-xs-12 col-md-offset-3">
                                <input type="submit" class="btn btn-success" name="btn_sub" value="Submit">
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- ✅ REPORT TABLE -->
    <div class="row">
        <div class="col-md-12 col-xs-12">
            <div class="x_panel">
                <div class="x_title">
                    <h2>Report</h2>
                    <div class="clearfix"></div>
                </div>
                <div class="x_content">
                    <table id="datatable-keytable" class="table table-striped table-bordered">
                        <thead>
                            <tr>
                                <th>Sr No</th>
                                <th>UserName</th>
                                <th>Game</th>
                                <th>Added On</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                                $sql=mysqli_query($connect,"SELECT * FROM tbl_user_game ORDER BY id DESC");
                                $no=1;
                                while($row=mysqli_fetch_assoc($sql))
                                {
                                    $userId=$row['userId'];
                                    $gameId=$row['gameId'];
                                    $added_on=$row['added_on'];

                                    $user=mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM tbl_user_register WHERE uid='$userId'"));
                                    $game=mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM game WHERE sr_no='$gameId'"));

                                    $renewal_date = date('Y-m-d', strtotime($added_on . ' +30 days'));
                                    $today = date('Y-m-d');

                                    // ✅ Auto expire users if 30 days passed
                                    if($today > $renewal_date && $user['status'] == 0){
                                        mysqli_query($connect, "UPDATE tbl_user_register SET status='1' WHERE uid='$userId'");
                                        $user['status'] = 1;
                                    }

                                    echo "<tr";
                                    if($user['status'] == 1){ echo " style='background-color:#ffe6e6;'"; }
                                    echo ">";

                                    echo "<td>$no</td>
                                          <td>{$user['username']}</td>
                                          <td>{$game['game']}</td>
                                          <td>".date('d-m-Y',strtotime($added_on))."</td>";

                                    // ✅ Display current status
                                    echo "<td>";
                                    if($user['status'] == 1){
                                        echo "<span style='color:red;font-weight:bold;'>Expired ($renewal_date)</span>";
                                    } else {
                                        echo "<span style='color:green;font-weight:bold;'>Active till ".date('d-m-Y', strtotime($renewal_date))."</span>";
                                    }
                                    echo "</td>";

                                    // ✅ Action buttons
                                    echo "<td>";
                                    if($user['status'] == 1){
                                        echo "<a href='user_select_game.php?renew_user=$userId' class='btn btn-warning btn-xs' style='padding:3px 8px;font-weight:bold;'>Renew</a> ";
                                    }
                                    echo "<a onclick='remove_user({$row['id']})'>
                                            <span class='glyphicon glyphicon-trash' style='color:red;font-size:20px;margin-left:6px'></span>
                                          </a>";
                                    echo "</td></tr>";

                                    $no++;
                                }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function remove_user(id){
    var del = confirm("Are you sure want to delete this record?");
    if(del){
        $.ajax({
            type: "POST",
            url: "include/remove_user_game.php",
            data: {id:id},
            success: function(data){
                alert(data);
                location.href="user_select_game.php";
            }
        });
    }
}
</script>

<?php
// ✅ Assign Game Logic
// ✅ Assign Game Logic
if(isset($_POST['btn_sub']))
{
    $username=$_POST['username'];
    $game=$_POST['game'];
    $date=date('Y-m-d');

    // prevent duplicate game assign to same user
    $check=mysqli_query($connect,"SELECT * FROM tbl_user_game WHERE userId='$username' AND gameId='$game'");
    if(mysqli_num_rows($check)>0){
        echo "<script>
                alert('This game is already assigned to the user.');
                location.href='user_select_game.php';
              </script>";
        exit;
    }

    // ⚠️ no_of_days untouched — market ke hisaab se hai
    $insert=mysqli_query($connect,"INSERT INTO tbl_user_game (userId, gameId, added_on) VALUES ('$username','$game','$date')");
    if($insert){
        mysqli_query($connect, "UPDATE tbl_user_register SET status='0' WHERE uid='$username'");
        echo "<script>
                alert('Game assigned successfully!');
                location.href='user_select_game.php';
              </script>";
    }
}

include('datatable.php');
mysqli_close($connect);
?>
