<?php
/**
 * ✅ SRIDEVI AUTO SCRAPER (FINAL VERSION)
 * ✔ Inserts only complete results
 * ✔ Skips incomplete/future dates
 * ✔ No duplicates
 */

date_default_timezone_set("Asia/Kolkata");

// ✅ Live DB Credentials
$host = "localhost";
$user = "dpbosssattamatka_kannadauser"; 
$pass = "Ashok@2025"; 
$db   = "dpbosssattamatka_kannada";

$mysqli = new mysqli($host, $user, $pass, $db);

if ($mysqli->connect_error) {
    die("❌ Database connection failed: " . $mysqli->connect_error);
}

$market = "SRIDEVI";
$tableName = "game_" . strtoupper($market);
$url = "https://dpboss.boston/panel-chart-record/sridevi.php";

$html = @file_get_contents($url);
if (!$html) {
    die("❌ Failed to load URL: $url");
}

libxml_use_internal_errors(true);
$dom = new DOMDocument();
$dom->loadHTML($html);
libxml_clear_errors();

$xpath = new DOMXPath($dom);
$rows = $xpath->query("//table//tbody//tr");

$total_inserted = 0;

foreach ($rows as $row) {
    $cells = $row->getElementsByTagName("td");
    if ($cells->length < 2) continue;

    // ✅ Extract date range correctly
    $dateText = preg_replace("/\s+/", "", trim($cells->item(0)->textContent));
    if (!preg_match("/(\d{2}\/\d{2}\/\d{4})to(\d{2}\/\d{2}\/\d{4})/", $dateText, $m)) continue;

    $start = DateTime::createFromFormat('d/m/Y', $m[1]);
    $end   = DateTime::createFromFormat('d/m/Y', $m[2]);

    $dates = [];
    while ($start <= $end) {
        $dates[] = $start->format('Y-m-d');
        $start->modify('+1 day');
    }

    // ✅ Parse 3 columns per day (open, jodi, close)
    $dayIndex = 0;
    for ($i = 1; $i + 2 < $cells->length && $dayIndex < 7; $i += 3) {
        $open  = preg_replace('/\D/', '', trim($cells->item($i)->textContent));
        $jodi  = preg_replace('/\D/', '', trim($cells->item($i + 1)->textContent));
        $close = preg_replace('/\D/', '', trim($cells->item($i + 2)->textContent));
        $date  = $dates[$dayIndex] ?? null;

        // ✅ Skip incomplete or future data
        if (!$date || strlen($open) != 3 || strlen($jodi) != 2 || strlen($close) != 3) {
            $dayIndex++;
            continue;
        }

        $formatted = "$open-$jodi-$close";

        // ✅ Avoid duplicate results
        $check = $mysqli->prepare("SELECT COUNT(*) FROM $tableName WHERE result_date=?");
        $check->bind_param("s", $date);
        $check->execute();
        $check->bind_result($count);
        $check->fetch();
        $check->close();

        if ($count == 0) {
            $stmt = $mysqli->prepare("INSERT INTO $tableName (name, result, result_date, date, status)
                VALUES (?, ?, ?, NOW(), '0')");
            if ($stmt) {
                $stmt->bind_param("sss", $market, $formatted, $date);
                $stmt->execute();
                $stmt->close();
                $total_inserted++;
            }
        }

        $dayIndex++;
    }
}

$mysqli->close();

echo "✅ SRIDEVI Update Done — New Records Inserted: $total_inserted\n";
?>
