<?php
include '../includes/db.php'; // ✅ correct your include path

header('Content-Type: application/json');

if (!isset($_POST['id'])) {
    echo json_encode(['error' => 'No ID provided']);
    exit;
}

$id = intval($_POST['id']);

$stmt = $pdo->prepare("SELECT * FROM user_free_fix WHERE id = ?");
$stmt->execute([$id]);
$row = $stmt->fetch(PDO::FETCH_ASSOC);

if ($row) {
    echo json_encode([
        'id' => $row['id'],
        'game_name' => $row['game'],
        'single_result' => $row['result'], // ✅ matches DB column
        'jodi_result' => $row['jodiResult'],
        'panna_result' => $row['pannaResult'],
        'date' => $row['date']
    ]);
} else {
    echo json_encode(['error' => 'Record not found']);
}
?>
