<?php
include 'config.php';

echo "<h2>Detailed Table Analysis</h2>";

$url = "https://sattamatkakannada.in/supreme-day-panel-chart.php";
$content = @file_get_contents($url);

if ($content === FALSE) {
    die("Failed to retrieve the webpage");
}

$dom = new DOMDocument();
libxml_use_internal_errors(true);
$dom->loadHTML($content);
libxml_clear_errors();

$xpath = new DOMXPath($dom);

// Find the panel table
$tables = $xpath->query("//table[contains(@class, 'panel')]");
if ($tables->length === 0) {
    die("No panel table found");
}

$table = $tables->item(0);
$rows = $table->getElementsByTagName('tr');

echo "Found table with " . $rows->length . " rows<br><br>";

// Analyze first 10 rows in detail
for ($i = 0; $i < min(10, $rows->length); $i++) {
    echo "<div style='border: 2px solid #007bff; margin: 10px; padding: 10px; background: #f8f9fa;'>";
    echo "<h3>Row $i Analysis:</h3>";
    
    $row = $rows->item($i);
    
    // Check for both td and th cells
    $cells_td = $row->getElementsByTagName('td');
    $cells_th = $row->getElementsByTagName('th');
    
    echo "TD cells: " . $cells_td->length . "<br>";
    echo "TH cells: " . $cells_th->length . "<br>";
    
    // Use whichever has cells
    if ($cells_td->length > 0) {
        $cells = $cells_td;
        $cell_type = "TD";
    } else {
        $cells = $cells_th;
        $cell_type = "TH";
    }
    
    echo "Using $cell_type cells<br><br>";
    
    foreach ($cells as $cellIndex => $cell) {
        $cell_content = trim($cell->textContent);
        $html_content = trim($cell->nodeValue);
        
        echo "<div style='margin: 5px; padding: 5px; background: white; border: 1px solid #ddd;'>";
        echo "<strong>Cell $cellIndex ($cell_type):</strong><br>";
        echo "Text Content: '<span style='color: blue;'>" . htmlspecialchars($cell_content) . "</span>'<br>";
        echo "Raw Length: " . strlen($cell_content) . "<br>";
        echo "Has numbers: " . (preg_match('/\d/', $cell_content) ? 'YES' : 'NO') . "<br>";
        echo "Has hyphens: " . (strpos($cell_content, '-') !== false ? 'YES' : 'NO') . "<br>";
        
        // Check for date patterns
        $date_patterns = [
            '/\d{1,2}-\d{1,2}-\d{4}/', // dd-mm-yyyy
            '/\d{1,2}\/\d{1,2}\/\d{4}/', // dd/mm/yyyy
            '/\d{4}-\d{1,2}-\d{1,2}/', // yyyy-mm-dd
        ];
        
        $is_date = false;
        foreach ($date_patterns as $pattern) {
            if (preg_match($pattern, $cell_content)) {
                $is_date = true;
                break;
            }
        }
        echo "Looks like date: " . ($is_date ? 'YES' : 'NO') . "<br>";
        echo "</div>";
    }
    echo "</div>";
}

// Also check what makes rows get skipped
echo "<h3>Row Filtering Analysis</h3>";

$processed = 0;
$skipped = 0;

for ($i = 0; $i < min(20, $rows->length); $i++) {
    $row = $rows->item($i);
    $cells_td = $row->getElementsByTagName('td');
    $cells_th = $row->getElementsByTagName('th');
    
    $cells = $cells_td->length > 0 ? $cells_td : $cells_th;
    
    if ($cells->length < 3) {
        echo "Row $i: SKIPPED - Only " . $cells->length . " cells<br>";
        $skipped++;
        continue;
    }
    
    $date_text = trim($cells->item(0)->textContent);
    $open_result = trim($cells->item(1)->textContent);
    $close_result = trim($cells->item(2)->textContent);
    
    $clean_open = preg_replace('/[^0-9\-]/', '', $open_result);
    $clean_close = preg_replace('/[^0-9\-]/', '', $close_result);
    
    echo "<div style='margin: 5px; padding: 5px; border: 1px solid " . 
         (empty($date_text) || empty($clean_open) || empty($clean_close) ? 'red' : 'green') . ";'>";
    echo "Row $i: Date='$date_text', Open='$open_result', Close='$close_result'<br>";
    echo "Cleaned: Open='$clean_open', Close='$clean_close'<br>";
    
    if (empty($date_text)) {
        echo "❌ SKIP: Empty date<br>";
        $skipped++;
    } elseif (empty($clean_open)) {
        echo "❌ SKIP: Empty open result<br>";
        $skipped++;
    } elseif (empty($clean_close)) {
        echo "❌ SKIP: Empty close result<br>";
        $skipped++;
    } elseif (preg_match('/[a-zA-Z]/', $date_text) && !is_numeric(str_replace(['-', '/', ' '], '', $date_text))) {
        echo "❌ SKIP: Date looks like text header<br>";
        $skipped++;
    } else {
        echo "✅ WOULD PROCESS THIS ROW<br>";
        $processed++;
    }
    echo "</div>";
}

echo "<h3>Summary:</h3>";
echo "Would process: $processed rows<br>";
echo "Would skip: $skipped rows<br>";
?>