<?php
// ---------------------------
//  DATABASE CONNECTION
// ---------------------------
$host = "localhost";
$user = "dpbosssattamatka_kannadauser";
$pass = "Ashok@2025";
$db   = "dpbosssattamatka_kannada";

$conn = mysqli_connect($host, $user, $pass, $db);
if (!$conn) {
    die("❌ Database connection failed: " . mysqli_connect_error());
}

// ---------------------------
//  MARKETS CONFIG
// ---------------------------
// Add all your markets here
$markets = [
       "KANNADA_NIGHT"  => "https://sattamatkakannada.in/kannada-night-panel-chart.php",
    // aur bhi add kar sakta hai...
];

// ---------------------------
//  FUNCTION: GET HTML TABLE DATA
// ---------------------------
function get_results_from_dpboss($url) {
    $html = @file_get_contents($url);
    if (!$html) return [];

    $dom = new DOMDocument();
    @$dom->loadHTML($html);
    $rows = $dom->getElementsByTagName('tr');
    $data = [];

    foreach ($rows as $row) {
        $cols = $row->getElementsByTagName('td');
        if ($cols->length >= 3) {
            $date   = trim($cols->item(0)->textContent);
            $open   = trim($cols->item(1)->textContent);
            $close  = trim($cols->item(2)->textContent);
            $result = "$open-$close";

            // Normalize date
            $date = str_replace('/', '-', $date);
            $timestamp = strtotime($date);
            if ($timestamp) {
                $date = date('Y-m-d', $timestamp);
            }

            // Filter invalid results
            if (!preg_match('/\d{1,3}\-\d{1,2}\-\d{1,3}/', $result)) continue;

            $data[] = [
                'date'   => $date,
                'result' => $result
            ];
        }
    }
    return $data;
}

// ---------------------------
//  MAIN LOOP
// ---------------------------
foreach ($markets as $market_name => $url) {
    echo "<h3>Fetching: $market_name ($url)</h3>";

    $table = "game_" . strtoupper(str_replace(' ', '_', $market_name));

    // Check if table exists
    $check = mysqli_query($conn, "SHOW TABLES LIKE '$table'");
    if (mysqli_num_rows($check) == 0) {
        echo "⚠️ Table $table does not exist! Skipping...<br>";
        continue;
    }

    // Fetch data from Dpboss
    $results = get_results_from_dpboss($url);
    if (empty($results)) {
        echo "❌ No results found for $market_name<br>";
        continue;
    }

    foreach ($results as $row) {
        $date   = $row['date'];
        $result = $row['result'];

        // Check duplicate entry
        $dup_check = mysqli_query($conn, "SELECT 1 FROM `$table` WHERE result_date='$date' LIMIT 1");
        if (mysqli_num_rows($dup_check) > 0) {
            echo "🟡 Already Exists: $market_name - $date - $result<br>";
            continue;
        }

        // Get next sr_no
        $max = mysqli_query($conn, "SELECT MAX(sr_no) AS maxno FROM `$table`");
        $rowMax = mysqli_fetch_assoc($max);
        $next_sr = $rowMax['maxno'] + 1;

        $now = date('Y-m-d H:i:s');

        $insert = "INSERT INTO `$table` (`sr_no`, `name`, `result`, `result_date`, `date`, `status`)
                   VALUES ('$next_sr', '$market_name', '$result', '$date', '$now', '0')";

        if (mysqli_query($conn, $insert)) {
            echo "✅ Inserted: $market_name - $date - $result<br>";
        } else {
            echo "❌ Error inserting $market_name - $date: " . mysqli_error($conn) . "<br>";
        }
    }

    echo "<hr>";
}

mysqli_close($conn);
echo "<b>✅ All markets processed successfully!</b>";
?>
